use std::ffi::c_void;

#[cfg(target_os = "windows")]
pub mod logged_in {
    use windows::Win32::System::RemoteDesktop::WTSGetActiveConsoleSessionId;
    use windows::Win32::System::Threading::GetCurrentProcessId;

    #[link(name = "kernel32")]
    extern "system" {
        pub fn ProcessIdToSessionId(pid: u32, session_id: *mut u32) -> i32;
    }

    #[napi]
    pub fn logged_in() -> bool {
        unsafe {
            let pid = GetCurrentProcessId();
            let mut session_id = 0;
            let success = ProcessIdToSessionId(pid, &mut session_id as *mut u32);

            if !success == 0 {
                return false;
            }

            let active_session_id = WTSGetActiveConsoleSessionId();

            if session_id == active_session_id {
                return true;
            }

            false
        }
    }
}

#[cfg(not(target_os = "windows"))]
#[napi]
pub fn logged_in() -> bool {true}
